#!/bin/bash

# Array of URLs
urls=(
    "https://docs.cpanel.net/changelogs/122-change-log/"
    "https://docs.cpanel.net/changelogs/120-change-log/"
    "https://docs.cpanel.net/changelogs/118-change-log/"
    "https://docs.cpanel.net/changelogs/116-change-log/"
    "https://docs.cpanel.net/changelogs/114-change-log/"
    "https://docs.cpanel.net/changelogs/112-change-log/"
    "https://docs.cpanel.net/changelogs/110-change-log/"
    "https://docs.cpanel.net/changelogs/108-change-log/"
    "https://docs.cpanel.net/changelogs/106-change-log/"
    "https://docs.cpanel.net/changelogs/104-change-log/"
    "https://docs.cpanel.net/changelogs/102-change-log/"
    "https://docs.cpanel.net/changelogs/100-change-log/"
    "https://docs.cpanel.net/changelogs/98-change-log/"
    "https://docs.cpanel.net/changelogs/96-change-log/"
    "https://docs.cpanel.net/changelogs/94-change-log/"
    "https://docs.cpanel.net/changelogs/92-change-log/"
    "https://docs.cpanel.net/changelogs/90-change-log/"
    "https://docs.cpanel.net/changelogs/88-change-log/"
    "https://docs.cpanel.net/changelogs/86-change-log/"
    "https://docs.cpanel.net/changelogs/84-change-log/"
    "https://docs.cpanel.net/changelogs/82-change-log/"
    "https://docs.cpanel.net/changelogs/80-change-log/"
    "https://docs.cpanel.net/changelogs/78-change-log/"
    "https://docs.cpanel.net/changelogs/76-change-log/"
    "https://docs.cpanel.net/changelogs/74-change-log/"
    "https://docs.cpanel.net/changelogs/72-change-log/"
    "https://docs.cpanel.net/changelogs/70-change-log/"
    "https://docs.cpanel.net/changelogs/68-change-log/"
    "https://docs.cpanel.net/changelogs/66-change-log/"
    "https://docs.cpanel.net/changelogs/64-change-log/"
    "https://docs.cpanel.net/changelogs/62-change-log/"
    "https://docs.cpanel.net/changelogs/60-change-log/"
    "https://docs.cpanel.net/changelogs/58-change-log/"
    "https://docs.cpanel.net/changelogs/56-change-log/"
    "https://docs.cpanel.net/changelogs/54-change-log/"
)

# Directory to save downloaded files
mkdir -p changelogs

# Base URL for downloading files
base_url="https://cpanel.resellercenter.ir/cpanelv5/files"

# Loop through each URL and process
for url in "${urls[@]}"; do
    version=$(echo $url | grep -oP '(?<=/changelogs/)\d+(?=-change-log)')
    filename="changelogs/${version}-change-log.html"
    wget -q -O "$filename" "$url"
    grep -oP '\d+\.\d+\.\d+' "$filename" | sort -u | while read -r ver; do
        major=$(echo $ver | cut -d. -f1)
        if [ "$major" -ge 54 ] && [ "$major" -le 122 ]; then
            # Define the URLs for license.php and sanity.php
            license_url="${base_url}/11.${ver}/license.php"
            sanity_url="${base_url}/11.${ver}/sanity.php"
            
            # Check if the files exist
            curl -s -f -o /dev/null "$license_url"
            license_exists=$?
            curl -s -f -o /dev/null "$sanity_url"
            sanity_exists=$?
            
            if [ $license_exists -eq 0 ] || [ $sanity_exists -eq 0 ]; then
                # Create directory with the prefix 11.
                dir="11.${ver}"
                mkdir -p "$dir"
                
                # Download the files into the directory if they exist
                if [ $license_exists -eq 0 ]; then
                    curl -s -f -o "${dir}/license.php" "$license_url"
                    echo "Downloaded license.php for version $ver into directory $dir"
                else
                    echo "license.php not found for version $ver"
                fi
                
                if [ $sanity_exists -eq 0 ]; then
                    curl -s -f -o "${dir}/sanity.php" "$sanity_url"
                    echo "Downloaded sanity.php for version $ver into directory $dir"
                else
                    echo "sanity.php not found for version $ver"
                fi
            else
                echo "Both files not found for version $ver. Skipping directory creation."
            fi
        fi
    done
done

